//
//  MCAlert.h
//  MCApplication
//
//  Created by Kevin Hiscott on 30/12/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import "MCWindowController.h"

extern NSString* MCLocalizedURLResourceKey;


@interface MCAlert : MCWindowController {
	NSString *_okString;
	NSString *_details;
	NSAttributedString *_additionalInformation;
	NSAttributedString *_resourceString;
	NSString *_title;
	NSImage  *_image;
	NSImage  *_appImage;
	NSString *_domain;
	
	BOOL hideAdditionalInformation;
	BOOL hideURLResource;
	
	IBOutlet NSButton *okButton;
	IBOutlet NSImageView *imageView;
	IBOutlet NSTextField *titleTextField;
	IBOutlet NSTextField *detailsTextField;
	IBOutlet NSBox *additionalInformationBox;
	IBOutlet NSScrollView *additionalScrollView;
	IBOutlet NSTextView *additionalTextView;
	IBOutlet NSTextField *urlResourceTextView;
	
	int resultCode;
}

+ (MCAlert *) alertWithError: (NSError *)error;
+ (MCAlert *) alertWithMessageText: (NSString *)messageTitle
					informativeText: (NSString *)informativeText
		  additionalInformationText: (NSString *)additionalText
					  defaultButton: (NSString *)defaultButtonTitle;
+ (MCAlert *) alertWithMessageText: (NSString *)messageTitle
				   informativeText: (NSString *)informativeText
		 additionalInformationText: (id)additionalText
					   urlResource: (NSString *)urlResource
					 defaultButton: (NSString *)defaultButtonTitle;
+ (MCAlert *) alertWithMessageText: (NSString *)messageTitle
				   informativeText: (NSString *)informativeText
		 additionalInformationText: (id)additionalText
					   urlResource: (NSString *)urlResource
							domain: (NSString *)domain
					 defaultButton: (NSString *)defaultButtonTitle;

- (IBAction)ok:(id)sender;
- (IBAction)showAdditionalInformation:(id)sender;
- (void)runModal;
- (void)sizeToFit;
- (void)resizeWindowByHeight:(float)deltaHeight;

- (NSString *)okString;
- (void)setOkString:(NSString *)anOkString;
- (NSAttributedString *)additionalInformation;
- (void)setAdditionalInformation:(NSAttributedString *)anAdditionalInformation;
- (NSString *)details;
- (void)setDetails:(NSString *)aDescription;
- (NSString *)title;
- (void)setTitle:(NSString *)aTitle;
- (int)resultCode;
- (void)setResultCode:(int)aResultCode;
- (NSImage *)image;
- (void)setImage:(NSImage *)anImage;
- (NSImage *)appImage;
- (void)setAppImage:(NSImage *)anImage;
- (BOOL)hideAdditionalInformation;
- (void)setHideAdditionalInformation:(BOOL)flag;
- (BOOL)hideURLResource;
- (void)setHideURLResource:(BOOL)flag;
+ (NSAttributedString*)_hyperLinkString:(NSString*)string withURLString: (NSString*)link;
- (void)setUrlResourceString:(NSString *)URLString;
-(void)setDomain:(NSString*)domain;
-(NSString *)domain;

@end
